package gov.va.med.mhv.health.repository;

import gov.va.med.mhv.health.model.MedicalEvent;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MedicalEventRepository extends JpaRepository<MedicalEvent, Long>{
	
	
    @Query("select a from MedicalEvent a where a.userprofileId = :userprofileid order by a.startDate asc")
	 List<MedicalEvent>  getMedicalEventsForUser(@Param ("userprofileid") Long userprofileid);
    
    
    @Query("select a from MedicalEvent a where a.userprofileId = :userprofileid order by a.startDate asc")
	 List<MedicalEvent>  getDashBoardMedicalEventsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);


}
